//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "main.h"
#include "math.h"
/********************** set-up of include pathes ****************************
Please note: you have to set up the pathes to the include files before
this sample program can be compiled:
Use the command "Project/Options", select the "Directories/Conditional"
tab, and add the required packages to the "include path"

example:
   if you installed the packages into the default directory, the
   include path for the BasePack will be: "C:\SDLSuite\basepack\C6"

More information can be found in the following FAQ article:
   http://forum.sdlsuite.com/read.php?f=2&i=21&t=21
*****************************************************************************/
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "SDL_math1"
#pragma link "SDL_rchart"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ButExitClick(TObject *Sender)
{
Close();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::RChart1ScaleTickDrawn(TObject *Sender,
      TCanvas *Canvas, TScaleType ScaleType, double CurrentTickPos,
      int ChartX, int ChartY)
{
AnsiString  astr;
int         tw;
int         th;

if (CBoxHexYScale->Checked == TRUE)
  {
  if (ScaleType == sctYR)
    {
    astr = "($"+Hex(ceil(CurrentTickPos),4)+")";
    tw = Canvas->TextWidth(astr);
    th = Canvas->TextHeight(astr);
    Canvas->TextOut (ChartX-tw-8, ChartY+(th/2), astr);
    }
  }

}
//---------------------------------------------------------------------------

void __fastcall TForm1::RChart1DataRendered(TObject *Sender,
      TCanvas *Canvas, int Top, int Left)
{
int     xout, yout;

Canvas->Font->Color = clBlue;
Canvas->TextOut (100,100, "text position: absolute");
Canvas->Pen->Color = clLime;
Canvas->Pen->Width = 5;
Canvas->MoveTo (93,95);
Canvas->LineTo (260,95);
Canvas->LineTo (260,120);
Canvas->LineTo (93,120);
Canvas->LineTo (93,95);
Canvas->Pen->Width = 1;
Canvas->Font->Color = clRed;
RChart1->R2M (1, 20.0, -1.3, xout,yout);
Canvas->TextOut (xout-Left, yout-Top, "text position: relative to the data");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CBoxHexYScaleClick(TObject *Sender)
{
RChart1->Invalidate();

}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormShow(TObject *Sender)
{
int   i;

RChart1->MoveTo (0,0);
for (i=1; i<=100; i++)
  {
  RChart1->DrawTo (i,sin(0.2*i));
  }
}
//---------------------------------------------------------------------------
