(********************************************************************)
(*                                                                  *)
(*                                                                  *)
(*                          S P L I N E                             *)
(*                                                                  *)
(*                          Version 1.0                             *)
(*                                                                  *)
(*     (C) 2004 H. Lohninger                          Apr-2000      *)
(*              Epina GmbH                                          *)
(*              A-3013 Pressbaum, Austria, Europe                   *)
(*              http://www.lohninger.com/                           *)
(*                                                                  *)
(*     Last Update: Mar-28, 2004                                    *)
(*                                                                  *)
(*  The program "Spline" is a Delphi sample program to show the     *)
(*  the calculation of splines                                      *)
(*                                                                  *)
(********************************************************************)

unit uspline;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, Grids, ExtCtrls,
  SDL_math2, SDL_NumLab, SDL_rchart;

type
  TForm1 = class(TForm)
    RChart1: TRChart;
    Panel1: TPanel;
    CBNat1: TCheckBox;
    CBNatN: TCheckBox;
    SBDeriv1: TScrollBar;
    SBDerivN: TScrollBar;
    NLab1: TNumLab;
    NLabN: TNumLab;
    BButExit: TBitBtn;
    CurveFit: TCurveFit;
    SBarSmoothFact: TScrollBar;
    NLabSmoothing: TNumLab;

    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CBNat1Click(Sender: TObject);
    procedure CBNatNClick(Sender: TObject);
    procedure SBDeriv1Change(Sender: TObject);
    procedure SBDerivNChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure RChart1MouseMoveInChart(Sender: TObject; InChart: Boolean;
      Shift: TShiftState; rMousePosX, rMousePosY: Double);
    procedure BButExitClick(Sender: TObject);
    procedure CBoxSmoothedSplineClick(Sender: TObject);
    procedure SBarSmoothFactChange(Sender: TObject);
  private
    SuppressCalc : boolean;
    procedure CalcAndShowSpline;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses
  SDL_Math1;


(******************************************************************************)
procedure TForm1.CalcAndShowSpline;
(******************************************************************************)

var
  i       : integer;
  x, y    : double;
  valid   : boolean;
  adouble : double;

begin
if not SuppressCalc then
  begin
  CurveFit.Init;
  for i:=0 to RChart1.NumItems-1 do    // loop through all items and enter MarkAt coords into CurveFit
    begin
    if RChart1.DataContainer[i].ItemKind = tkMarkAt then
      CurveFit.EnterStatValue (RChart1.DataContainer[i].x, RChart1.DataContainer[i].Y);
    end;
  if CurveFit.NumData > 0 then          // draw spline
    begin
    RChart1.RemoveItemsByClass (100);   // remove the previous spline curve
    RChart1.DataColor := clblue;
    RChart1.ClassDefault := 100;
    if SBarSmoothFact.Position <> 0
      then begin                        // draw the smoothed spline
           CurveFit.SplineSmoothingFactor := SBarSmoothFact.Position/1000;
           x := CurveFit.MinX;
           y := CurveFit.SmoothedSpline (x, adouble, valid);
           RChart1.MoveTo (x,y);
           for i:=1 to 400 do
             begin
             x := CurveFit.MinX+i*0.25;
             y := CurveFit.SmoothedSpline (x, adouble, valid);
             if valid then
               RChart1.DrawTo (x,y);
             end;
           end
      else begin
           RChart1.MoveTo (0, CurveFit.CubicSpline (0));  //now draw the new spline
           for i:=1 to 400 do
             begin
             y := CurveFit.CubicSpline (i/4);
             RChart1.DrawTo(i/4,y);
             end;
           end;
    RChart1.ShowGraf;
    end;
  end;
end;


(******************************************************************************)
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
(******************************************************************************)

begin
CUrveFit.Free;
end;

(******************************************************************************)
procedure TForm1.CBNat1Click(Sender: TObject);
(******************************************************************************)

begin
if CBNat1.Checked
  then begin
       NLab1.Visible := false;
       SBDeriv1.Visible := false;
       end
  else begin
       NLab1.Visible := true;
       SBDeriv1.Visible := true;
       end;
CurveFit.SplineNatural1 := CBNat1.Checked;
CalcAndShowSpline;
end;


(******************************************************************************)
procedure TForm1.CBNatNClick(Sender: TObject);
(******************************************************************************)

begin
if CBNatN.Checked
  then begin
       NLabN.Visible := false;
       SBDerivN.Visible := false;
       end
  else begin
       NLabN.Visible := true;
       SBDerivN.Visible := true;
       end;
CurveFit.SplineNaturalN := CBNatN.Checked;
CalcAndShowSpline;
end;


(******************************************************************************)
procedure TForm1.SBDeriv1Change(Sender: TObject);
(******************************************************************************)

begin
CurveFit.SplineDerivY1 := SBDeriv1.Position/1000;
NLab1.Value := CurveFit.SplineDerivY1;
CalcAndShowSpline;
end;

(******************************************************************************)
procedure TForm1.SBDerivNChange(Sender: TObject);
(******************************************************************************)

begin
CurveFit.SplineDerivYN := SbDerivN.Position/1000;
NLabN.Value := CurveFit.SplineDerivYN;
CalcAndShowSpline;
end;


(******************************************************************************)
procedure TForm1.FormShow(Sender: TObject);
(******************************************************************************)

const
  MaxDPoints = 6;
  DPoints : array[1..MaxDPoints, 1..2] of double =
             ((20,2), (44,3), (30,5), (64,6), (33,7), (53,5.2));

var
  i : integer;

begin
RChart1.ClearGraf;
RChart1.DataColor := clRed;
for i:=1 to MaxDPoints do
  RChart1.MarkAt (DPoints[i,1],DPoints[i,2],24);
SuppressCalc := false;
CurveFit.SplineNatural1 := CBNat1.Checked;
CurveFit.SplineNaturalN := CBNatN.Checked;
CalcAndShowSpline;
end;


(******************************************************************************)
procedure TForm1.RChart1MouseMoveInChart(Sender: TObject; InChart: Boolean;
  Shift: TShiftState; rMousePosX, rMousePosY: Double);
(******************************************************************************)

var
  GElem   : integer;
  i       : integer;
  ElemPar : TrcChartItem;
  ElemPar2: TrcChartItem;
  dist    : double;
  equal   : boolean;

begin
if (ssLeft in Shift) then
  begin
  GElem := RChart1.FindNearestItemScreen (rMousePosX, rMousePosY, tkMArkAt, 255, Dist);
  if GElem >= 0 then
    begin
    ElemPar := RChart1.getItemparams (GElem);
      // since splines cannot be calculated if two points have the same x-coordinates
      // we have to prevent equal x-coordinates
    equal := false;
    for i:=0 to RChart1.NumItems-1 do     // loop through all items and check if any x-coord. equals the mouse position
      begin
      ElemPar2 := RChart1.getItemparams (i);
      if (ElemPar2.ItemKind = tkMarkAt) and (i <> GElem) then
        begin
        if ElemPar2.x = rMousePosX then
          equal := true;
        end;
      end;
    if not equal then
      begin
      ElemPar.x := rMousePosX;   // move mark to mouse cursor
      ElemPar.y := rMousePosY;
      RChart1.SetItemParams (GElem, ElemPar);
      end;
    end;
  CalcAndShowSpline;
  end;
end;

(******************************************************************************)
procedure TForm1.BButExitClick(Sender: TObject);
(******************************************************************************)

begin
close;
end;

(******************************************************************************)
procedure TForm1.CBoxSmoothedSplineClick(Sender: TObject);
(******************************************************************************)

begin
CalcAndShowSpline;
end;

(******************************************************************************)
procedure TForm1.SBarSmoothFactChange(Sender: TObject);
(******************************************************************************)

begin
NLabSmoothing.Value := SBarSmoothFact.Position/1000;
if SBarSmoothFact.Position = 0
  then begin
       CBNat1.Enabled := true;
       CBNatN.Enabled := true;
       NLab1.Enabled := true;
       SBDeriv1.Enabled := true;
       NLabN.Enabled := true;
       SBDerivN.Enabled := true;
       end
  else begin
       CBNat1.Enabled := false;
       CBNatN.Enabled := false;
       NLab1.Enabled := false;
       SBDeriv1.Enabled := false;
       NLabN.Enabled := false;
       SBDerivN.Enabled := false;
       end;
CalcAndShowSpline;
end;

end.



