unit frmmain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, SDL_replist, StdCtrls;

type
  TForm1 = class(TForm)
    ButCreateRandnum: TButton;
    RLRand: TReportListView;
    ButSort: TButton;
    RLSorted: TReportListView;
    procedure ButCreateRandnumClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ButSortClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses
  SDL_stringl, SDL_math1, SDL_sdlbase;

const
  ARRAYSIZE = 20;

var
  arr1 : array[1..ARRAYSIZE] of double;  // static array with fixed number of elements
  arr2 : array of double;                // dynamic array


(******************************************************************************)
procedure TForm1.ButCreateRandnumClick(Sender: TObject);
(******************************************************************************)

var
  i : integer;

begin
RLRand.NrOfRows := ARRAYSIZE;
RLSorted.NrOfRows := ARRAYSIZE;
RLSorted.FRLData.Strings.Clear;
RLSorted.Refresh;

RLRand.SuppressPaint := true;
SetLength (arr2, ARRAYSIZE);     // set size of dynamic array
for i:=1 to ARRAYSIZE do
  begin
  arr1[i] := random;
  RLRand[1,i] := strff(arr1[i],1,4);
  arr2[i-1] := random;
  RLRand[2,i] := strff(arr2[i-1],1,4);
  end;
RLRand.SuppressPaint := false;
end;

(******************************************************************************)
procedure TForm1.ButSortClick(Sender: TObject);
(******************************************************************************)

var
  i : integer;

begin
RLSorted.SuppressPaint := true;

{ sort the static array:
  reference to the array elements is provided by the @ operator }
SortArray (@arr1, ARRAYSIZE, dnum, true);

{ sort the dynamic array:
  the @ operator must not be used since dynamic arrays are implemented by pointers }
SortArray (arr2, ARRAYSIZE, dnum, true);

for i:=1 to ARRAYSIZE do
  begin
  RLSorted[1,i] := strff(arr1[i],1,4);
  RLSorted[2,i] := strff(arr2[i-1],1,4);
  end;
RLSorted.SuppressPaint := false;
end;

(******************************************************************************)
procedure TForm1.FormShow(Sender: TObject);
(******************************************************************************)

begin
RLRand.Header[1] := 'static array';
RLRand.Header[2] := 'dynamic array';
RLSorted.Header[1] := 'static array';
RLSorted.Header[2] := 'dynamic array';
end;

end.
