//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop
#include<math.h>
#include "tstspeed.h"
/********************** set-up of include pathes ****************************
Please note: you have to set up the pathes to the include files before
this sample program can be compiled:
Use the command "Project/Options", select the "Directories/Conditional"
tab, and add the required packages to the "include path"

example:
   if you installed the packages into the default directory, the
   include path for the BasePack will be: "C:\SDLSuite\basepack\C6"

More information can be found in the following FAQ article:
   http://forum.sdlsuite.com/read.php?f=2&i=21&t=21
*****************************************************************************/
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "SDL_numlab"
#pragma link "SDL_rchart"
#pragma resource "*.dfm"
TForm1 *Form1;
const int MaxNumData = 13;
const int NumData[MaxNumData] = {100,200,500,1000,2000,5000,10000,20000,50000,100000,200000,500000,1000000};

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ButExitClick(TObject *Sender)
{
Close();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ButStartClick(TObject *Sender)
{
int     i;
int     npoi;
double  t1, t2;

SWTime = Time();
npoi = int(NLabDatPoi->Value+0.5);
RChart1->ClearGraf();
RChart1->SetRange (1, 0,-5,npoi,5);
RChart1->DataColor = clRed;
RChart1->MoveTo (0,0);
for (i=1; i<=npoi; i++)
  {
  RChart1->DrawTo (i,2000.0/(400.0+i)*sin(0.01*i));
  }
t1 = 86400.0*(Time()-SWTime);
RChart1->ShowGraf();
t2 = 86400.0*(Time()-SWTime);
LblT1->Caption = "Time to draw internally: "+strff(t1,1,2)+ " sec";
LblT2->Caption = "Total drawing time: "+strff(t2,1,2)+" sec";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RBZoomClick(TObject *Sender)
{
RChart1->MouseAction = maZoomWindPos;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RBPanClick(TObject *Sender)
{
RChart1->MouseAction = maPan;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ScrollBar1Change(TObject *Sender)
{
RChart1->ClearGraf();
NLabDatPoi->Value = NumData[ScrollBar1->Position-1];
RChart1->Scale1X->RangeHigh = NumData[ScrollBar1->Position-1];
RChart1->ShowGraf();
}
//---------------------------------------------------------------------------
