unit Rchmov1;

{ This unit shows the application of the method RemoveLastToken
  two display moving graphics objects. Once a background is
  established (the dotted line) only the moving elements have to
  exhchanged on the linked list by first removing them and then
  redrawing them at another location }

{--------------------------------------------------------------}
interface
{--------------------------------------------------------------}

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, SDL_RChart, ExtCtrls;

type
  TForm1 = class(TForm)
    RChart1: TRChart;
    ButDone: TBitBtn;
    ButStart: TBitBtn;
    ButStop: TBitBtn;
    Bevel1: TBevel;
    CBLogX: TCheckBox;
    CBLogY: TCheckBox;
    Timer1: TTimer;
    procedure ButStartClick(Sender: TObject);
    procedure ButDoneClick(Sender: TObject);
    procedure ButStopClick(Sender: TObject);
    procedure CBLogXClick(Sender: TObject);
    procedure CBLogYClick(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Timer1Timer(Sender: TObject);
  private
    Obj1, Obj2 : integer;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

{--------------------------------------------------------------}
implementation

uses LogWarn;
{--------------------------------------------------------------}

{$R *.DFM}

const
  NPnts = 250;



(***************************************************************)
procedure TForm1.ButStartClick(Sender: TObject);
(***************************************************************)

var
  i   : integer;

begin
ButStop.Enabled := true;
ButStart.Enabled := false;
ButDone.Enabled := false;
RChart1.Scale1X.RangeLow := 0;
RChart1.Scale1X.RangeHigh := NPnts;
RChart1.Scale1Y.RangeLow := 10;
RChart1.Scale1Y.RangeHigh := 600;
RChart1.DataColor := clBlack;
RChart1.ClearGraf;
for i:= 1 to NPnts do
  RChart1.MarkAt (i, NPnts+i*sin(i*0.1), 0);
RChart1.ShowGraf;
RChart1.DataColor := clBlue;
RChart1.MarkAt (0,0,12);
RChart1.DataColor := clRed;
RChart1.MarkAt (0,0,12);
RChart1.ShowGraf;
Obj1 := 0;
Obj2 := 0;
Timer1.Enabled := true;
end;


(***************************************************************)
procedure TForm1.ButDoneClick(Sender: TObject);
(***************************************************************)

begin
close;
end;


(***************************************************************)
procedure TForm1.ButStopClick(Sender: TObject);
(***************************************************************)

begin
ButStop.Enabled := false;
ButStart.Enabled := true;
ButDone.Enabled := true;
Timer1.Enabled := false;
end;

(***************************************************************)
procedure TForm1.CBLogXClick(Sender: TObject);
(***************************************************************)

begin
if not CBLogX.Checked and (RChart1.Scale1X.RangeLow <= 0)
  then begin
       LogWarnForm.ShowModal;
       CBLogX.Checked := false;
       end
  else begin
       RChart1.Scale1X.Logarithmic := CBLogX.Checked;
       CBLogX.Checked := RChart1.Scale1X.Logarithmic;
       end;
end;

(***************************************************************)
procedure TForm1.CBLogYClick(Sender: TObject);
(***************************************************************)

begin
if not CBLogY.Checked and (RChart1.Scale1Y.RangeLow <= 0)
  then begin
       LogWarnForm.ShowModal;
       CBLogY.Checked := false;
       end
  else begin
       RChart1.Scale1Y.Logarithmic := CBLogY.Checked;
       CBLogY.Checked := RChart1.Scale1Y.Logarithmic;
       end;
end;


(***************************************************************)
procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
(***************************************************************)

begin
Screen.Cursor := crDefault;
end;

(***************************************************************)
procedure TForm1.Timer1Timer(Sender: TObject);
(***************************************************************)

begin
inc (Obj2,2);
if Obj2 > NPnts then
  Obj2 := 1;
inc (Obj1);
if Obj1 > Npnts then
  Obj1 := 1;
RChart1.RemoveLastItem;
RChart1.RemoveLastItem;
RChart1.DataColor := clRed;
RChart1.MarkAt (Obj1,NPnts+Obj1*sin(Obj1*0.1), 18);
RChart1.DataColor := clBlue;
RChart1.MarkAt (Obj2,NPnts+Obj2*sin(Obj2*0.1), 18);
RChart1.ShowGraf;
end;

end.
