unit Timser;


interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, printers, ExtCtrls, SDL_NumLab,
  SDL_rchart;

type
  TForm1 = class(TForm)
    RChart1: TRChart;
    ButDone: TButton;
    CBMX: TCheckBox;
    CBMY: TCheckBox;
    NumLab1: TNumLab;
    NumLab2: TNumLab;
    procedure FormActivate(Sender: TObject);
    procedure ButDoneClick(Sender: TObject);
    procedure CBMXClick(Sender: TObject);
    procedure CBMYClick(Sender: TObject);
    procedure RChart1MouseMoveInChart(Sender: TObject; InChart: Boolean;
      Shift: TShiftState; rMousePosX, rMousePosY: Double);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormShow(Sender: TObject);
  private
    procedure SetCrossHair;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses
  SDL_sdlbase;

(*******************************************************************)
procedure TForm1.FormActivate(Sender: TObject);
(*******************************************************************)

const
  Numval = 800;

var
  i : integer;

begin
RChart1.Scale1X.RangeHigh := NumVal;
RChart1.Scale1X.RangeLow := 0;
RChart1.Scale1Y.RangeHigh := 150;
RChart1.Scale1Y.RangeLow := -30;
RChart1.DataColor := clBlue;
RCHart1.MoveTo (0,0);
for i:=1 to NumVal do
  RChart1.DrawTo (i,i/10+i/30*sin(i*0.04)+20*(random+random));
RChart1.DataColor := clRed;
RChart1.MoveTo (0,40);
for i:=1 to NumVal do
  RChart1.DrawTo (i,40+i/20*sin(i*0.05));
end;

(*******************************************************************)
procedure TForm1.SetCrossHair;
(*******************************************************************)

begin
if CBMX.Checked
  then begin
       if CBMY.Checked
         then RChart1.CrossHairSetup (1, clTeal, chBoth, psSolid, 1)
         else RChart1.CrossHairSetup (1, clTeal, chVert, psSolid, 1);
       end
  else begin
       if CBMY.Checked
         then RChart1.CrossHairSetup (1, clTeal, chHoriz, psSolid, 1)
         else RChart1.CrossHairSetup (1, clTeal, chOff, psSolid, 1);
       end;

end;


(*******************************************************************)
procedure TForm1.ButDoneClick(Sender: TObject);
(*******************************************************************)

begin
close;
end;

(*******************************************************************)
procedure TForm1.CBMXClick(Sender: TObject);
(*******************************************************************)

begin
Numlab1.Visible := CBMX.Checked;
SetCrossHair;
end;

(*******************************************************************)
procedure TForm1.CBMYClick(Sender: TObject);
(*******************************************************************)

begin
NumLab2.Visible := CBMY.Checked;
SetCrossHair;
end;


(*******************************************************************)
procedure TForm1.RChart1MouseMoveInChart(Sender: TObject; InChart: Boolean;
  Shift: TShiftState; rMousePosX, rMousePosY: Double);
(*******************************************************************)

begin
NumLab1.Empty := not Inchart;
NumLab2.Empty := not Inchart;
NumLab1.Value := rMousePosX;
NumLab2.Value := rMousePosY;
RChart1.CrossHairSetPos (1, rMousePosX, rMousePosY);
end;


(*******************************************************************)
procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
(*******************************************************************)

begin
Screen.Cursor := crDefault;
end;

(*******************************************************************)
procedure TForm1.FormShow(Sender: TObject);
(*******************************************************************)

begin
SetCrossHair;
end;

end.
