//---------------------------------------------------------------------------
#pragma hdrstop

#include "dragitem.h"
#include "math.h"
/********************** set-up of include pathes ****************************
Please note: you have to set up the pathes to the include files before
this sample program can be compiled:
Use the command "Project/Options", select the "Directories/Conditional"
tab, and add the required packages to the "include path"

example:
   if you installed the packages into the default directory, the
   include path for the BasePack will be: "C:\SDLSuite\basepack\C6"

More information can be found in the following FAQ article:
   http://forum.sdlsuite.com/read.php?f=2&i=21&t=21
*****************************************************************************/
//---------------------------------------------------------------------------
#pragma link "SDL_rchart"
#pragma resource "*.dfm"
TForm1 *Form1;
bool MarkedMove = false;
bool FirstMove = true;
int LastPosX, LastPosY;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SbMarkClick(TObject *Sender)
{
double xLo, YLo, XHi, YHi;

PnlStat->Caption = "Select the data to move";
MarkedMove = SBDrag->Down;
if (RChart1->MouseBox (xLo, YLo, XHi, YHi) == true)
  {
  RChart1->MarkItemsInWindow (xLo, YLo, XHi, YHi, tkMarkAt, 99);
  RChart1->NewColorOfClassItems (clBlue, 99);
  RChart1->ShowGraf();
  }
SbMark->Down = False;
SBDrag->Down = True;
MarkedMove = SBDrag->Down;
PnlStat->Caption = "Drag the data by clicking the chart and draging the mouse";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SBDragClick(TObject *Sender)
{
MarkedMove = SBDrag->Down;
if (MarkedMove == true)
  {
  PnlStat->Caption = "Drag the data by clicking the chart and draging the mouse";
  }
else
  {
  PnlStat->Caption = "";
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SBClearMarksClick(TObject *Sender)
{
SBDrag->Down = False;
RChart1->MarkAllItems (tkEverything, 0);
RChart1->NewColorOfClassItems (clRed, 0);
RChart1->ShowGraf();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::BBtDoneClick(TObject *Sender)
{
Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormActivate(TObject *Sender)
{
const int Numval = 200;
int i;

RChart1->Scale1X->RangeHigh = Numval;
RChart1->Scale1X->RangeLow = 0;
RChart1->Scale1Y->RangeHigh = 10;
RChart1->Scale1Y->RangeLow = -10;
RChart1->DataColor = clRed;
for (i=1; i<=Numval; i++)
  RChart1->MarkAt (double(i),i/20.0*sin(i*0.15)*cos(i*0.062),4);
RChart1->MoveTo (0,0); // dummy token for FindNext-example
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RChart1MouseMove(TObject *Sender, TShiftState Shift,
        int X, int Y)
{
double rx, ry, rx2, ry2;

if (Shift.Contains(ssLeft) && (MarkedMove == true))
  {
  if (FirstMove == true)
    {
    FirstMove = false;
    LastPosX = X;
    LastPosY = Y;
    }
  else
    {
    RChart1->M2R (1,X,Y,rx,ry);
    RChart1->M2R (1,LastPosX,LastPosY,rx2,ry2);
    RChart1->ScaleSelectedItems (1,rx-rx2,1,ry-ry2,99);
    RChart1->ShowGraf();
    LastPosX = X;
    LastPosY = Y;
    }
  }
else
  {
  FirstMove = True;
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormMouseMove(TObject *Sender, TShiftState Shift, int X,
        int Y)
{
Screen->Cursor = crDefault;
}
//---------------------------------------------------------------------------